REDEPLOY=false
TARGET_DIR="."
UPDATE_DONE=false
CALLRET=0
APP_HOME=$(pwd)

# Check if JAVA_HOME is set or locate the java binary in the system's PATH
if [ -z "$JAVA_HOME" ]; then
    JAVA_BIN=$(which java)
    if [ -z "$JAVA_BIN" ]; then
        echo "JAVA_HOME is not set and 'java' binary not found in PATH. Please set JAVA_HOME or add 'java' to your PATH."
        exit 1
    else
        JAVA_CMD="$JAVA_BIN"
    fi
else
    JAVA_CMD="$JAVA_HOME/bin/java"
fi

AppStart () {
    CLASSPATH="$APP_HOME:$APP_HOME/cco/lib/*:$APP_HOME/cco/envLib/*:$APP_HOME/cco/POSPlugins/Translations/"
    echo "AppStart"
    $JAVA_CMD -server \
         -Xmx768m \
         -XX:+HeapDumpOnOutOfMemoryError \
         -Dapp.home="$APP_HOME" \
         -Djava.library.path="$APP_HOME/cco/lib" \
         -Dfile.encoding=UTF-8 \
         -DNGUI_LOW_PERFORMANCE_MODE=true \
         $LOGBACK_CFG \
         -Dredeploy=$REDEPLOY \
         -DupdateDone=$UPDATE_DONE \
         -cp $CLASSPATH \
         -splash:splash.png \
         -javaagent:ENV.jar \
         com.sap.scco.env.Runner
    CALLRET=$?
}

Backup(){
    CLASSPATH="$APP_HOME:$APP_HOME/cco/lib/*:$APP_HOME/cco/envLib/*:$APP_HOME/cco/POSPlugins/Translations/"
    echo "BackUp"

    SHUTDOWN_SYSTEM=""
    if [ "$1" -eq "96" ];
    then
    SHUTDOWN_SYSTEM="-shutdownsystem"
    fi

    $JAVA_CMD -Dapp.home="$APP_HOME" -cp $CLASSPATH com.sap.scco.ap.backup.ApplicationBackupManager $TARGET_DIR "\XXX" 7 7 $SHUTDOWN_SYSTEM
}

osstr=`uname`
if [[ "$OSTYPE" == 'Linux' ]]; then
  platform='linux'
  USERPROFILE="~/"
elif [[ "$OSTYPE" == 'FreeBSD' ]]; then
  platform='freebsd'
  USERPROFILE="~/"
elif [[ "$OSTYPE" == 'cygwin' ]]; then
  platform='windows'
  # USERPROFILE is defined by default on windows systems
  USERPROFILE=${USERPROFILE//\\/\/}
fi

APP_HOME=$BYD_POS_HOME
if [[ "$APP_HOME" == '' ]]; then
  APP_HOME=`pwd`
fi

BREAK_FLAG=0

until [ "$BREAK_FLAG" -eq 1 ]
do
    rm -fR tomcat.999?
    rm -fR tomcat.8080

    if [ -e "$APP_HOME/cco/updates/ENV.jar" ];
    then
      echo Update found ...
      if [ -d "$APP_HOME/cco/updates/cco/envLib" ];
      then
        rm -rf $TARGET_DIR/cco/envLib
      fi
      cp $APP_HOME/cco/updates/ENV.jar $TARGET_DIR/ENV.jar
      cp $APP_HOME/cco/updates/version.txt $TARGET_DIR/version.txt
      cp $APP_HOME/cco/updates/splash.png $TARGET_DIR/splash.png
      cp $APP_HOME/cco/updates/cco.ico $TARGET_DIR/cco.ico
      cp -rf $APP_HOME/cco/updates/cco $TARGET_DIR
      cp -r $APP_HOME/cco/updates/tools $TARGET_DIR/tools
      cp -r $APP_HOME/cco/updates/doc $TARGET_DIR/doc
      rm -f $APP_HOME/cco/updates/ENV.*
      rm -f $APP_HOME/cco/updates/version.txt
      rm -f $APP_HOME/cco/updates/*.bat
      rm -f $APP_HOME/cco/updates/splash.png
      rm -f $APP_HOME/cco/updates/cco.ico
      rm -rf $APP_HOME/cco/updates/cco
      rm -rf $APP_HOME/cco/updates/backup
      rm -rf $APP_HOME/cco/updates/tools
      rm -rf $APP_HOME/cco/updates/doc
      UPDATE_DONE=true
      REDEPLOY=true
      echo ENV.jar copied. Executing update...
    fi
    echo $APP_HOME

    if [ -e "$APP_HOME/cco/conf/logback.xml" ];
    then
      LOGBACK_CFG=-Dlogback.configurationFile="$APP_HOME/cco/conf/logback.xml"
    fi

    echo $LOGBACK_CFG

    AppStart
    echo $CALLRET
    echo "STOP_CCO Bye"

    if [[ "$CALLRET" -eq "96" || "$CALLRET" -eq "97" ]];
    then
        Backup $CALLRET
        BREAK_FLAG=1
        break
    elif [ "$CALLRET" -eq "98" ];
    then
        continue
    elif [ "$CALLRET" -eq "99" ];
    then
        echo Update done. Restarting...
        UPDATE_DONE=false
        REDEPLOY=false
        CALLRET=0
        continue
    else
        BREAK_FLAG=1
        break
    fi
done
echo "STOP_CCO Bye"
