/*
 * Decompiled with CFR 0.152.
 */
package com.sap.customercheckout.tools.restore.helper;

import com.sap.customercheckout.tools.restore.helper.CCOHelper;
import com.sap.scco.ap.pos.dao.CDBSession;
import com.sap.scco.ap.pos.dao.CDBSessionFactory;
import com.sap.scco.ap.pos.i14y.central.CentralServerIntegrationHelper;
import com.sap.scco.ap.pos.i14y.central.rest.CentralServerRestClientBase;
import com.sap.scco.ap.pos.security.EncryptionHandler;
import com.sap.scco.ap.pos.security.EncryptionService;
import com.sap.scco.ap.pos.sequencenumber.SequenceNumberRegistry;
import com.sap.scco.ap.pos.service.SecurityPosService;
import com.sap.scco.ap.pos.service.ServiceFactory;
import com.sap.scco.util.conf.CConfig;
import com.sap.scco.util.exception.WrongConfigurationException;
import com.sap.scco.util.rest.RestClient;
import com.sap.scco.util.rest.RestClientException;
import com.sap.scco.util.update.CManifestInfo;
import com.sap.scco.util.utilities.MonitoringAdditionalOption;
import com.sap.scco.util.utilities.MonitoringEventNumber;
import com.sap.scco.util.utilities.MonitoringHub;
import com.sap.scco.util.utilities.MonitoringHubGroupKey;
import com.sap.scco.util.utilities.MonitoringHubKey;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.util.UrlEncoded;

public class CCOmHelper
implements Serializable {
    public static final String RESULT_LIST = "resultList";
    private final transient CentralServerRestClientBase restClient;

    public CCOmHelper(CCOHelper helper) throws RestClientException, IOException {
        if (helper == null) {
            throw new NullPointerException();
        }
        SecurityPosService securityPosService = (SecurityPosService)ServiceFactory.INSTANCE.getOrCreateServiceInstance(SecurityPosService.class);
        EncryptionHandler.INSTANCE.initialize((EncryptionService)securityPosService);
        ServiceFactory.INSTANCE.initRestClients();
        this.restClient = CentralServerIntegrationHelper.buildRestClient();
        this.restClient.executeLogin();
        JSONObject connectionResult = this.restClient.executeCall("internal/ping", RestClient.HTTPMethod.GET, null);
        if (connectionResult.isEmpty()) {
            throw new WrongConfigurationException("WRONG_PATH");
        }
    }

    private static JSONObject getFilterJSONObject(String value, boolean include) {
        JSONObject filterObject = new JSONObject();
        filterObject.put((Object)"mode", (Object)(include ? "include" : "exclude"));
        filterObject.put((Object)"operator", (Object)"eq");
        filterObject.put((Object)"value", (Object)value);
        return filterObject;
    }

    public void sendLog(String posSystemId) {
        CManifestInfo manifestInfo = CConfig.INSTANCE.getManifestInfo();
        ArrayList<MonitoringAdditionalOption> options = new ArrayList<MonitoringAdditionalOption>();
        options.add(new MonitoringAdditionalOption("POS System Id", posSystemId));
        options.add(new MonitoringAdditionalOption("Version", manifestInfo.getCustomerVersion() + " " + manifestInfo.getVersion()));
        MonitoringHub.getInstance().pushInformationMessage(Integer.valueOf(MonitoringEventNumber.RESTORATION.getEventNumber()), "Restoration was successful", MonitoringHubGroupKey.SYSTEM, MonitoringHubKey.RESTORE, options, false, true);
    }

    public String getLastReceiptFromServer(String ccoPrefix) throws RestClientException, IOException {
        String receiptId = null;
        try (CDBSession dbSession = CDBSessionFactory.instance.createSession();){
            List<String> receiptConsumers = this.selectSequenceConsumers("RECEIPT", dbSession);
            String url = this.getReceiptQuery(ccoPrefix, receiptConsumers);
            JSONObject result = this.restClient.executeCall(url, RestClient.HTTPMethod.GET, null);
            JSONArray jsonArray = result.getJSONArray(RESULT_LIST);
            if (!jsonArray.isEmpty()) {
                receiptId = jsonArray.getJSONObject(0).getString("id");
            }
        }
        return receiptId;
    }

    public String getLastCashDeskClosingFromServer(String ccoPrefix) throws RestClientException, IOException {
        String url = "/internal/summary-transaction/last-id?posId=" + ccoPrefix;
        JSONObject result = this.restClient.executeCall(url, RestClient.HTTPMethod.GET, null);
        String cashDeskClosingId = null;
        if (result != null) {
            cashDeskClosingId = result.get("id").toString();
        }
        return cashDeskClosingId;
    }

    public String getReceiptTypeCodeEnumByConsumer(String consumerName) {
        if (SequenceNumberRegistry.Consumer.RECEIPT_SALES.name().equals(consumerName)) {
            return "1";
        }
        if (SequenceNumberRegistry.Consumer.RECEIPT_SALES_RESERVE.name().equals(consumerName)) {
            return "12";
        }
        if (SequenceNumberRegistry.Consumer.RECEIPT_CASH_IN.name().equals(consumerName)) {
            return "2";
        }
        if (SequenceNumberRegistry.Consumer.RECEIPT_CASH_OUT.name().equals(consumerName)) {
            return "3";
        }
        if (SequenceNumberRegistry.Consumer.RECEIPT_PAY_IN.name().equals(consumerName)) {
            return "8";
        }
        if (SequenceNumberRegistry.Consumer.RECEIPT_PAY_OUT.name().equals(consumerName)) {
            return "9";
        }
        if (SequenceNumberRegistry.Consumer.RECEIPT_CASH_DESK_CLOSING_CASH_BALANCING.name().equals(consumerName)) {
            return "7";
        }
        if (SequenceNumberRegistry.Consumer.RECEIPT_CASH_DESK_CLOSING_CASH_IN.name().equals(consumerName)) {
            return "5";
        }
        if (SequenceNumberRegistry.Consumer.RECEIPT_CASH_DESK_CLOSING_CASH_OUT.name().equals(consumerName)) {
            return "6";
        }
        return null;
    }

    private String getReceiptQuery(String ccoPrefix, List<String> sequenceConsumers) {
        JSONArray consumerArray = new JSONArray();
        for (String consumer : sequenceConsumers) {
            consumerArray.add((Object)CCOmHelper.getFilterJSONObject(this.getReceiptTypeCodeEnumByConsumer(consumer), true));
        }
        JSONObject unitObject = new JSONObject();
        JSONArray idArray = new JSONArray();
        idArray.add((Object)CCOmHelper.getFilterJSONObject(ccoPrefix, true));
        unitObject.put((Object)"id", (Object)idArray);
        JSONObject filterObject = new JSONObject();
        filterObject.put((Object)"unit", (Object)unitObject);
        filterObject.put((Object)"typeCode", (Object)consumerArray);
        return "internal/receipt?order=-metadata.originCreatedAt&top=1&filter=" + UrlEncoded.encodeString((String)filterObject.toString());
    }

    private List<String> selectSequenceConsumers(String sequenceName, CDBSession dbSession) {
        sequenceName = StringUtils.upperCase((String)sequenceName);
        Query query = dbSession.getEM().createNativeQuery("SELECT CONSUMER FROM SEQUENCENUMBERCONSUMER c JOIN SEQUENCE_NUMBER_CONSUMER snc ON c.OBJECTKEY = snc.FK_CONSUMER WHERE snc.FK_SEQUENCE_NUMBER = (SELECT OBJECTKEY FROM SEQUENCENUMBER WHERE UPPER(NAME) = ?)");
        query.setParameter(1, (Object)sequenceName);
        return query.getResultList();
    }
}

