#!/bin/bash

#-----------------------------------------------------------------------------
#Functions
#-----------------------------------------------------------------------------
use_java_home() {
if [ -z "$JAVA_HOME" ]; 
then
exit 0
fi
JAVA_ROOT_DIR="$JAVA_HOME"
echo "Java root directory is set to $JAVA_ROOT_DIR (using JAVA_HOME env variable)"
}

define_java_cmd() {
if [ ! -d "$JAVA_ROOT_DIR/jre" ]; then
jre
else
if [ ! -f "$JAVA_ROOT_DIR/jre/bin/server/jvm.dll" ]; then
exit 0
fi
JRE_LIB="-server"
JAVA_CMD="$JAVA_ROOT_DIR/jre/bin/java"
fi
}

jre() {
JAVA_CMD="$JAVA_ROOT_DIR/bin/java"
}

define_cco_path() {
CCO_PATH=$(pwd)
echo "CCO path is set to $CCO_PATH"
}

parse_args() {
while [ "$#" -gt 0 ]; do
if [ "$1" == "$CCO_PATH_ARG" ]; then
CCO_PATH="$2"
elif [ "$1" == "$CCO_PREFIX_ARG" ]; then
CCO_PREFIX="$2"
elif [ "$1" == "$CCO_COMPANY_ID_ARG" ]; then
CCO_COMPANY_ID="$2"
elif [ "$1" == "$STORE_ID_ARG" ]; then
STORE_ID="$2"
elif [ "$1" == "$ALT_POS_ID_ARG" ]; then
ALT_POS_ID="$2"
elif [ "$1" == "$IDOC_READ_LOC_ARG" ]; then
IDOC_READ_LOC="$2"
fi
shift 2
done
}

define_silent_command() {
SILENT_CMD="$JAVA_CMD -Xmx768m -DccoPath=$CCO_PATH -Dapp.home=$APP_HOME"
if [ -n "$CCO_PREFIX" ]; then
SILENT_CMD="$SILENT_CMD -Dprefix=$CCO_PREFIX"
fi
if [ -n "$CCO_COMPANY_ID" ]; then
SILENT_CMD="$SILENT_CMD -DcompanyId=$CCO_COMPANY_ID"
fi
if [ -n "$STORE_ID" ]; then
SILENT_CMD="$SILENT_CMD -DstoreId=$STORE_ID"
fi
if [ -n "$ALT_POS_ID" ]; then
SILENT_CMD="$SILENT_CMD -DaltPosId=$ALT_POS_ID"
fi
if [ -n "$IDOC_READ_LOC" ]; then
SILENT_CMD="$SILENT_CMD -DidocReadLocation=$IDOC_READ_LOC"
fi
SILENT_CMD="$SILENT_CMD -cp $MINIMAL_CLASSPATH com.sap.customercheckout.tools.restore.main.CCORestoreSilent"
}

#----------------------------------------------------------------------------
#Script to start the SAP Customer Checkout Restore Silent tool
#----------------------------------------------------------------------------
JAVA_CMD=java
APP_HOME=$(pwd)
echo "APP_HOME $APP_HOME"
APP_NAME="ENV.jar"
MINIMAL_CLASSPATH="$APP_HOME/$APP_NAME:$APP_HOME/cco/envLib/*"

#----------------------------------------------------------------------------
#Arguments
#----------------------------------------------------------------------------
CCO_PATH_ARG="-ccoPath"
CCO_PREFIX_ARG="-prefix"
CCO_COMPANY_ID_ARG="-companyId"
STORE_ID_ARG="-storeId"
ALT_POS_ID_ARG="-altPosId"
IDOC_READ_LOC_ARG="-idocReadLocation"

#----------------------------------------------------------------------------
CCO_JAVA_HOME="$CCO_JAVA_HOME"
JAVA_HOME="$JAVA_HOME"
JAVA_ROOT_DIR=""

if [ -z "$CCO_JAVA_HOME" ]; then
use_java_home
else
JAVA_ROOT_DIR="$CCO_JAVA_HOME"
echo "Java root directory is set to $JAVA_ROOT_DIR (using CCO_JAVA_HOME env variable)"
fi

if [ -n "$JAVA_ROOT_DIR" ]; 
then
define_java_cmd
fi

parse_args "$@"

if [ -z "$CCO_PATH" ]; 
then
define_cco_path
fi

echo "CCO_PATH $CCO_PATH"

define_silent_command
echo "Running $SILENT_CMD"
$SILENT_CMD


