/*
 * Decompiled with CFR 0.152.
 */
package com.sap.customercheckout.tools.restore.main;

import com.sap.customercheckout.tools.restore.frame.prefixchanger.util.CashDeskSettings;
import com.sap.customercheckout.tools.restore.frame.prefixchanger.util.ERPSettings;
import com.sap.customercheckout.tools.restore.frame.prefixchanger.util.SettingsChangeResult;
import com.sap.customercheckout.tools.restore.frame.prefixchanger.util.SettingsChanger;
import com.sap.customercheckout.tools.restore.helper.CCOHelper;
import com.sap.scco.util.translation.CustomTranslationFileHandler;
import com.sap.scco.util.translation.CustomTranslationFileHandlerCCO;
import com.sap.scco.util.translation.Translator;
import com.sap.scco.util.utilities.SecurityHelpers;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CCORestoreSilent {
    public static final String PROP_CCO_PATH = "ccoPath";
    public static final String PROP_PREFIX = "prefix";
    public static final String PROP_STORE_ID = "storeId";
    public static final String PROP_IDOC_READ_LOCATION = "idocReadLocation";
    public static final String PROP_ALT_POS_ID = "altPosId";
    private static final Logger logger = LoggerFactory.getLogger(CCORestoreSilent.class);

    public static void main(String[] args) {
        System.setProperty("log4j1.compatibility", "true");
        String propCCOPath = System.getProperty(PROP_CCO_PATH);
        if (StringUtils.isBlank((CharSequence)propCCOPath)) {
            System.out.println(Translator.T((String)"RESTORE_CCO_PATH_MISSING"));
            return;
        }
        File file = new File(SecurityHelpers.getSecurePath((String)propCCOPath));
        if (!file.exists()) {
            System.out.println(Translator.T((String)"RESTORE_EXCEPTION_DIRECTORY_NOT_FOUND"));
            return;
        }
        SettingsChanger settingsChanger = null;
        try {
            System.out.println(Translator.T((String)"RESTORE_INFO_CONNECTING"));
            CCOHelper.init(propCCOPath);
        }
        catch (IOException e) {
            System.out.println(Translator.T((String)"RESTORE_EXCEPTION_WRONG_CCO_PATH"));
            logger.error("Could not find a CCO installation in this directory", (Throwable)e);
            return;
        }
        settingsChanger = new SettingsChanger();
        SettingsChangeResult changeResult = settingsChanger.changeSettings(CCORestoreSilent.getCashDeskSettings(), CCORestoreSilent.getERPSettings());
        if (changeResult.isValidationFailed()) {
            System.out.println(changeResult.getErrorMessage());
        } else {
            System.out.println(changeResult.getFinalMessage());
        }
        System.exit(0);
    }

    private static ERPSettings getERPSettings() {
        ERPSettings erpSettings = null;
        if (CCOHelper.getInstance().isERPSupported()) {
            String newStoreId = System.getProperty(PROP_STORE_ID);
            String newIdocReadLocation = System.getProperty(PROP_IDOC_READ_LOCATION);
            String newAltPosId = System.getProperty(PROP_ALT_POS_ID);
            if (StringUtils.isNotBlank((CharSequence)newStoreId) || StringUtils.isNotBlank((CharSequence)newIdocReadLocation) || StringUtils.isNotBlank((CharSequence)newAltPosId)) {
                erpSettings = new ERPSettings(newStoreId, newIdocReadLocation, newAltPosId);
            }
        }
        return erpSettings;
    }

    private static CashDeskSettings getCashDeskSettings() {
        String newPrefix = System.getProperty(PROP_PREFIX);
        String serialNumber = "";
        return new CashDeskSettings(newPrefix, serialNumber);
    }

    static {
        Translator.INSTANCE.setCustomTranslationFileHandler((CustomTranslationFileHandler)new CustomTranslationFileHandlerCCO());
        Translator.INSTANCE.addTranslationFile("translations.labels");
        Translator.INSTANCE.addTranslationFile("translations.buttons");
        Translator.INSTANCE.addTranslationFile("translations.messages");
    }
}

