/*
 * Decompiled with CFR 0.152.
 */
package com.sap.customercheckout.tools.restore.frame.backuprecovery;

import com.sap.customercheckout.tools.restore.controller.NextFrameListener;
import com.sap.customercheckout.tools.restore.frame.base.BaseFrame;
import com.sap.customercheckout.tools.restore.helper.CCOHelper;
import com.sap.customercheckout.tools.restore.helper.CCOmHelper;
import com.sap.customercheckout.tools.restore.helper.FileHelper;
import com.sap.scco.util.exception.WrongConfigurationException;
import com.sap.scco.util.translation.Translator;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupRecoveryFrame
extends BaseFrame {
    private CCOmHelper mHelper;
    private String ccoPrefix;
    private CCOHelper helper;
    private static final Logger logger = LoggerFactory.getLogger(BackupRecoveryFrame.class);

    public BackupRecoveryFrame(NextFrameListener listener) {
        int yPosition = 20;
        JLabel labelToolName = new JLabel(Translator.T((String)"RESTORE_BACKUP_RECOVERY_TITEL"));
        labelToolName.setBounds(20, yPosition, 250, 20);
        this.add(labelToolName);
        JLabel labelTarget = new JLabel(Translator.T((String)"RESTORE_CCO_TARGET_DIRECTORY"));
        labelTarget.setBounds(20, yPosition += 30, 100, 20);
        this.add(labelTarget);
        JTextField targetField = new JTextField();
        targetField.setText("");
        targetField.setBounds(120, yPosition, 300, 20);
        targetField.setText("C:\\SapCustomerCheckout");
        this.add(targetField);
        JLabel labelBackup = new JLabel(Translator.T((String)"RESTORE_CCO_BACKUP_FILE"));
        labelBackup.setBounds(20, yPosition += 40, 100, 20);
        this.add(labelBackup);
        JTextField backupField = new JTextField();
        backupField.setText("");
        backupField.setBounds(120, yPosition, 300, 20);
        this.add(backupField);
        JButton buttonDiretoryPicker = new JButton(UIManager.getIcon("FileView.directoryIcon"));
        buttonDiretoryPicker.setBounds(425, yPosition, 30, 20);
        this.add(buttonDiretoryPicker);
        JButton buttonSubmit = new JButton(Translator.T((String)"RESTORE_NEXT_BUTTON"));
        buttonSubmit.setBounds(20, yPosition += 40, 100, 20);
        this.add(buttonSubmit);
        JButton buttonCDC = new JButton(Translator.T((String)"RESTORE_CCO_DO_CDC"));
        buttonCDC.setBounds(20, yPosition += 40, 300, 20);
        this.add(buttonCDC);
        buttonCDC.setVisible(false);
        buttonDiretoryPicker.addActionListener(e -> {
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File("."));
            chooser.setDialogTitle("Select CCO Backup Recovery file");
            chooser.setFileSelectionMode(0);
            FileNameExtensionFilter filter = new FileNameExtensionFilter(".zip", "zip");
            chooser.setFileFilter(filter);
            chooser.setAcceptAllFileFilterUsed(false);
            if (chooser.showOpenDialog(this) == 0) {
                String backupDirectory = chooser.getSelectedFile().toString();
                backupField.setText(backupDirectory);
            }
        });
        buttonSubmit.addActionListener(e -> this.showInProgress(Translator.T((String)"RESTORE_INFO_READING"), () -> {
            String newFileDir;
            String backupDirectory = backupField.getText();
            String sapCustomerCheckoutDirectory = targetField.getText();
            try {
                newFileDir = FileHelper.INSTANCE.renameDirectory(sapCustomerCheckoutDirectory, "OBSOLETE_CCO_" + System.currentTimeMillis());
            }
            catch (Exception e2) {
                logger.error("Could not rename directory", (Throwable)e2);
                JOptionPane.showMessageDialog(this, e2.getMessage());
                return;
            }
            if (backupDirectory.toLowerCase().contains(sapCustomerCheckoutDirectory.toLowerCase())) {
                backupDirectory = backupDirectory.replace(sapCustomerCheckoutDirectory, newFileDir);
            }
            try {
                FileHelper.INSTANCE.unzipFile(backupDirectory, sapCustomerCheckoutDirectory);
            }
            catch (IOException e1) {
                logger.error("Could not unzip file", (Throwable)e1);
                JOptionPane.showMessageDialog(this, Translator.T((String)"RESTORE_EXCEPTION_UNZIP_FILE"));
                return;
            }
            buttonSubmit.setEnabled(false);
            targetField.setEnabled(false);
            backupField.setEnabled(false);
            buttonDiretoryPicker.setEnabled(false);
            this.showInProgress(Translator.T((String)"RESTORE_INFO_CONNECTING"), () -> {
                if (this.helper == null) {
                    this.connectToCCO(targetField);
                }
                buttonCDC.setVisible(true);
            });
        }));
        buttonCDC.addActionListener(e -> {
            this.voidReceiptsAndFinishDayEndClosing();
            buttonCDC.setEnabled(false);
            this.buttonNextScreen.setVisible(true);
        });
        this.buttonNextScreen.addActionListener(e -> listener.openNextFrame(this, this.helper, this.mHelper, this.ccoPrefix));
    }

    private void connectToCCO(JTextField targetField) {
        try {
            CCOHelper.init(targetField.getText());
            this.helper = CCOHelper.getInstance();
            this.mHelper = new CCOmHelper(this.helper);
            this.ccoPrefix = this.helper.getCashDeskPrefix();
            this.mHelper.sendLog(this.ccoPrefix);
        }
        catch (WrongConfigurationException e1) {
            logger.error("Connection to CCOm not configured.", (Throwable)e1);
            JOptionPane.showMessageDialog(this, Translator.T((String)"RESTORE_EXCEPTION_MANAGER_CONNECTION_NOT_CONFIGURED"));
        }
        catch (Exception e2) {
            logger.error("Could not connect to SAP Customer Checkout manager", (Throwable)e2);
            JOptionPane.showMessageDialog(this, Translator.T((String)"RESTORE_EXCEPTION_MANAGER_CONNECTION"));
        }
    }

    private void voidReceiptsAndFinishDayEndClosing() {
        try {
            this.helper.voidNewReceipts();
            this.helper.finishCashDeskClosing();
            JOptionPane.showMessageDialog(this, Translator.T((String)"RESTORE_MSG_CDC_FINISHED"));
        }
        catch (Exception e1) {
            logger.error("Could not finish Day End closing", (Throwable)e1);
            JOptionPane.showMessageDialog(this, Translator.T((String)"RESTORE_EXCEPTION_CDC_CHANGE"));
        }
    }
}

